/*
Copyright (c) 2015 by Matei Copot (http://codepen.io/towc/pen/ZGqPZE) modified by Boom Apps

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
*/
jQuery(function($) {
	$.fn.hexagonizedWave = function(Settings) {
		var It = this;
		var c = $(this)[0];
		var w = c.width = $(this).parent().width(),
			h = c.height = $(this).parent().height(),
			ctx = c.getContext( '2d' ),
			opts = {
			  spacing: 50,
			  baseSize: 25,
			  addedSize: 20,
			  
			  multX: .5,
			  multY: 0.9,
			  multSum: 0.1,
			  tickSpeed: .01,
			  hueMult: 0,
			  saturation: 100,
			  lightness: 65,
			  opacity:1,
			  hueFrom: 336,
			  hueMax: 51,
			  shape: "circle"
			},
			
			tick = 0,
				rad = Math.PI / 6,
				sin = Math.sin( rad ),
				cos = Math.cos( rad ),
				xs,ys, drawPath;
				
			opts = $.extend(true, opts, Settings);
		function loop() {
		  
		  window.requestAnimationFrame( loop );
		  ctx.clearRect( 0, 0, w, h );
		  
		  tick += opts.tickSpeed;
		  var addedHue = tick * opts.hueMult,
			  difX = Math.sqrt( 3 ) * opts.spacing / 2,
			  difY = opts.spacing * 3 / 2,
			  limitX = c.width + opts.spacing,
			  limitY = c.height + opts.spacing;
		  
		  for( var x = 0; x < limitX; x += difX*2 ){
				var i = 0;
			
			for( var y = 0; y < limitY; y += difY ){
					++i;
					
					var x1 = x + difX * ( i % 2 );
					xTimesMult = x1 * opts.multX,
					hueX = opts.hueFrom + x1 / limitX * opts.hueMax + tick * opts.hueMult,
					size = opts.baseSize + opts.addedSize * Math.sin( ( xTimesMult + y * opts.multY ) * opts.multSum + tick );
			  
					ctx.fillStyle = 'hsla(' + hueX + ',' + opts.saturation + '%,'+ opts.lightness +'%,'+opts.opacity+')';
					ctx.beginPath();
					
					switch (opts.shape) {
						case "circle":
							ctx.arc(x1, y, size, 0, 2 * Math.PI, false);
							
							drawPath = false;
						break;
						
						case "square":
							xs = [ -1, 1, 1, -1 ];
							ys = [ -1, -1, 1, 1 ];
							drawPath = true;
						break;
						case "hexagon":
							xs = [ cos, 0, -cos, -cos, 0, cos ];
							ys = [ -sin, -1, -sin, sin, 1, sin ];
							drawPath = true;
						break;
						case "triangle":	
							xs = [ .5, 1, 0 ];
							ys = [ 0, .8, .8 ];	
							drawPath = true;		
						break;
					}	
					
					if (drawPath) {
						ctx.moveTo( xs[0] * size + x1, ys[0] * size + y );
						for( var n = 1; n < xs.length; ++n ) {
							ctx.lineTo( xs[n] * size + x1, ys[n] * size + y );
						}
					}
					ctx.fill();
			}
		  }
		}
		loop();


		$(window).resize( function(){
			w = c.width = $(It).parent().width();
			h = c.height = $(It).parent().height();
		});
	}
});